<?php

namespace App;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = false;
	protected $fillable = array('id', 'email', 'is_artist', 'is_admin', 'confirmed', 'confirmation_code', 'fb_id');
	protected $hidden = array('password', 'remember_token');

	public function profession()
	{
		return $this->belongsToMany('App\Profession');
	}

	public function association()
	{
		return $this->belongsToMany('App\Association');
	}

	public function profile()
	{
		return $this->hasOne('App\Profile');
	}

	public function curriculum()
	{
		return $this->hasOne('App\Curriculum');
	}

	public function artist_away()
	{
		return $this->hasOne('App\Artist_away');
	}

	public function follow()
	{
		return $this->hasOne('App\Follow');
	}

	public function profile_evaluation()
	{
		return $this->hasOne('App\Profile_evaluation');
	}

	public function follow1()
	{
		return $this->hasOne('App\Follow', 'follow_user_id1');
	}

	public function artwork()
	{
		return $this->hasMany('App\Artwork');
	}

	public function artworkfavorites()
	{
		return $this->belongsToMany('App\Artwork')->using('App\Favorites');
	}

}