<?php

namespace board;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Board extends Model 
{

    protected $table = 'boards';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function chapter()
    {
        return $this->belongsTo('Chapter');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

    public function guide()
    {
        return $this->belongsTo('Guide');
    }

    public function textbook()
    {
        return $this->belongsTo('Textbook');
    }

}