<?php

namespace textbook;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Textbook extends Model 
{

    protected $table = 'textbooks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function board()
    {
        return $this->hasOne('Board');
    }

    public function classe()
    {
        return $this->hasOne('Classe');
    }

    public function subject()
    {
        return $this->hasOne('Subject');
    }

}