<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizUserAnswersTable extends Migration {

	public function up()
	{
		Schema::create('quiz_user_answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('quiz_id')->unsigned();
			$table->bigInteger('question_id')->unsigned();
			$table->string('given_answers')->nullable();
			$table->datetime('quiz_started_time');
			$table->datetime('quiz_ended_time');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('quizresult_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quiz_user_answers');
	}
}