<?php

namespace classe;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Classe extends Eloquent {

	protected $table = 'classes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function chapter()
	{
		return $this->belongsTo('Chapter');
	}

	public function examtype()
	{
		return $this->belongsTo('ExamType');
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

	public function guide()
	{
		return $this->belongsTo('Guide');
	}

	public function textbook()
	{
		return $this->belongsTo('Textbook');
	}

}