<?php

namespace guidequestion;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GuideQuestion extends Eloquent {

	protected $table = 'guides_questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function guides()
	{
		return $this->hasMany('Guide');
	}

	public function quesiontype()
	{
		return $this->hasMany('QuestionType');
	}

	public function chapter()
	{
		return $this->hasMany('Chapter');
	}

}