<?php

namespace subject;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subject extends Eloquent {

	protected $table = 'subjects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function chapter()
	{
		return $this->belongsTo('Chapter');
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

	public function textbook()
	{
		return $this->belongsTo('Textbook');
	}

}