<?php

namespace textbook;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Textbook extends Eloquent {

	protected $table = 'textbooks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function board()
	{
		return $this->hasOne('Board');
	}

	public function classe()
	{
		return $this->hasOne('Classe');
	}

	public function subject()
	{
		return $this->hasOne('Subject');
	}

}