<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChaptersTable extends Migration {

	public function up()
	{
		Schema::create('chapters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('board_id')->unsigned()->nullable();
			$table->bigInteger('classe_id')->unsigned()->nullable();
			$table->bigInteger('subject_id')->unsigned()->nullable()->default('10');
			$table->string('name');
		});
	}

	public function down()
	{
		Schema::drop('chapters');
	}
}