<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVideosTable extends Migration {

	public function up()
	{
		Schema::create('videos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('board_id')->unsigned()->nullable();
			$table->bigInteger('classe_id')->unsigned()->nullable();
			$table->bigInteger('subject_id')->unsigned()->nullable();
			$table->bigInteger('chapter_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->string('video_url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('videos');
	}
}