<?php

namespace guide;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Guide extends Eloquent {

	protected $table = 'guides';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function guidquestion()
	{
		return $this->belongsTo('GuideQuestion');
	}

	public function board()
	{
		return $this->hasOne('Board');
	}

	public function classe()
	{
		return $this->hasOne('Classe');
	}

	public function subject()
	{
		return $this->hasOne('Subject');
	}

}