<?php

namespace question;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function quiz_question()
    {
        return $this->belongsTo('QuizQuestion');
    }

    public function classe()
    {
        return $this->hasMany('Classe');
    }

    public function subject()
    {
        return $this->hasMany('Subject');
    }

    public function chapter()
    {
        return $this->hasMany('Chapter');
    }

    public function examtype()
    {
        return $this->hasMany('ExamType');
    }

    public function board()
    {
        return $this->hasMany('Board');
    }

    public function quesiontype()
    {
        return $this->hasMany('QuestionType');
    }

    public function quizuseranswer()
    {
        return $this->belongsTo('QuizUserAnswer');
    }

}