<?php

namespace questiontype;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuestionType extends Model 
{

    protected $table = 'question_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function guidequestion()
    {
        return $this->belongsTo('GuideQuestion');
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

}