<?php

namespace quiz;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quiz extends Model 
{

    protected $table = 'quizes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userquiz()
    {
        return $this->belongsTo('UserQuiz');
    }

    public function quizquestion()
    {
        return $this->belongsTo('QuizQuestion');
    }

    public function board()
    {
        return $this->hasOne('Board');
    }

    public function classe()
    {
        return $this->hasOne('Classe');
    }

    public function subject()
    {
        return $this->hasOne('Subject');
    }

    public function chapter()
    {
        return $this->hasOne('Chapter');
    }

    public function quizresult()
    {
        return $this->belongsTo('QuizResult');
    }

    public function quizuseranswer()
    {
        return $this->belongsTo('QuizUserAnswer');
    }

}