<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantTable extends Migration {

	public function up()
	{
		Schema::create('tenant', function(Blueprint $table) {
			$table->increments('id_tenant');
			$table->timestamps();
			$table->string('tenant_name', 25)->unique();
			$table->string('tenant_address', 100);
			$table->string('tenant_phone', 20);
			$table->datetime('expire_date');
			$table->string('contract_num', 30)->nullable();
			$table->string('logo', 25);
			$table->enum('active', array('yes', 'no'));
			$table->text('info');
		});
	}

	public function down()
	{
		Schema::drop('tenant');
	}
}