<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PurchaseOrder extends Eloquent {

	protected $table = 'purchase_order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function supplier()
	{
		return $this->hasOne('Suppliers', 'id_supplier');
	}

	public function poItems()
	{
		return $this->hasMany('PoItems', 'id_poitems');
	}

	public function paymentType()
	{
		return $this->hasOne('PaymentTypes', 'id_paytype');
	}

	public function tenant()
	{
		return $this->hasOne('Tenant', 'id_tenant');
	}

}