<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id_user');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_level')->unsigned();
			$table->string('user_name', 25)->unique();
			$table->string('uname', 25)->unique();
			$table->string('passwd', 255);
			$table->enum('active', array('yes', 'no'));
			$table->datetime('last_login');
			$table->rememberToken();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}