<?php

namespace angkasapos;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Goods extends Eloquent {

	protected $table = 'goods';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function units()
	{
		return $this->hasOne('Units', 'id_units');
	}

	public function category()
	{
		return $this->hasOne('Categories', 'id_category');
	}

	public function supplier()
	{
		return $this->hasOne('Suppliers', 'id_supplier');
	}

	public function rack()
	{
		return $this->hasOne('Racks', 'id_rack');
	}

	public function stocks()
	{
		return $this->hasOne('Stocks', 'id_stock');
	}

	public function discount()
	{
		return $this->hasOne('Discount', 'id_discount');
	}

	public function tenant()
	{
		return $this->hasOne('Tenant', 'id_tenant');
	}

}