<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellingTable extends Migration {

	public function up()
	{
		Schema::create('selling', function(Blueprint $table) {
			$table->increments('id_selling');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_discount')->unsigned();
			$table->integer('id_paytype')->unsigned();
			$table->integer('id_sellingitem');
			$table->integer('id_customer');
			$table->timestamps();
			$table->softDeletes();
			$table->string('invoice_num', 26)->unique()->default('INV/SD/1234/08/2016/000001');
			$table->bigInteger('paid');
			$table->bigInteger('change');
			$table->enum('debt', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('selling');
	}
}