<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTable extends Migration {

	public function up()
	{
		Schema::create('discount', function(Blueprint $table) {
			$table->increments('id_discount');
			$table->integer('id_tenant')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('discount_type', 10);
			$table->smallInteger('percent');
			$table->datetime('expired')->nullable();
			$table->enum('disable', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('discount');
	}
}