<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseOrderTable extends Migration {

	public function up()
	{
		Schema::create('purchase_order', function(Blueprint $table) {
			$table->increments('id_po');
			$table->integer('id_tenant')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_supplier')->unsigned()->nullable();
			$table->integer('id_poitems')->unsigned();
			$table->integer('id_paytype')->unsigned();
			$table->string('po_invoice_num', 25)->unique()->default('INV/PO/1234/08/2016/00001');
			$table->integer('amount');
			$table->string('po_requester', 25);
			$table->enum('credit', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('purchase_order');
	}
}