<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnItemsTable extends Migration {

	public function up()
	{
		Schema::create('return_items', function(Blueprint $table) {
			$table->increments('id_returnitem');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_goods')->unsigned();
			$table->integer('id_paytype')->unsigned();
			$table->integer('id_supplier')->unsigned()->nullable();
			$table->datetime('return_date');
			$table->string('barcode', 25);
			$table->string('goods_name', 25);
			$table->integer('amount');
			$table->bigInteger('purchase_price');
		});
	}

	public function down()
	{
		Schema::drop('return_items');
	}
}