<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGoodsReceiptTable extends Migration {

	public function up()
	{
		Schema::create('goods_receipt', function(Blueprint $table) {
			$table->increments('id_gr');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_supplier')->unsigned();
			$table->integer('id_gritem');
			$table->timestamps();
			$table->softDeletes();
			$table->string('gr_invoice_num', 25)->unique()->default('INV/GR/1234/08/2016/00001');
			$table->string('po_invoice_num', 25)->unique()->nullable();
			$table->string('receiver', 25);
		});
	}

	public function down()
	{
		Schema::drop('goods_receipt');
	}
}