<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGoodsTable extends Migration {

	public function up()
	{
		Schema::create('goods', function(Blueprint $table) {
			$table->increments('id_goods');
			$table->integer('id_tenant')->unsigned();
			$table->integer('id_units')->unsigned();
			$table->integer('id_category')->unsigned();
			$table->integer('id_supplier')->unsigned()->nullable();
			$table->integer('id_rack')->unsigned()->nullable();
			$table->integer('id_stock')->unsigned();
			$table->integer('id_discount');
			$table->string('barcode', 25)->unique();
			$table->string('goods_name', 25)->unique();
			$table->bigInteger('selling_price');
			$table->bigInteger('purchase_price');
			$table->timestamps();
			$table->enum('deleted', array('yes', 'no'));
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('goods');
	}
}