<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnGoodsTable extends Migration {

	public function up()
	{
		Schema::create('return_goods', function(Blueprint $table) {
			$table->increments('id_rg');
			$table->integer('id_tenant')->unsigned();
			$table->string('return_invoice_number', 17)->unique()->default('INV/RG/1234/00001');
			$table->integer('id_returnitem');
			$table->bigInteger('total_return_price');
			$table->text('reason')->nullable();
			$table->string('returnee', 25);
		});
	}

	public function down()
	{
		Schema::drop('return_goods');
	}
}