<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('classe_id')->unsigned();
			$table->integer('fournisseur_id')->unsigned()->nullable();
			$table->integer('projet_id')->unsigned()->index();
			$table->integer('compte_id')->unsigned()->index();
			$table->integer('regrouptrans_id')->unsigned()->index();
			$table->integer('regroupcategorie_id')->unsigned();
			$table->integer('transcategorie_id')->unsigned()->index();
			$table->date('date')->index();
			$table->string('detail', 100);
			$table->decimal('montant', 8,2)->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}