<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBudgetsTable extends Migration {

	public function up()
	{
		Schema::create('budgets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('compte_id')->unsigned()->index();
			$table->integer('regrouptrans_id')->unsigned();
			$table->date('begda');
			$table->date('endda');
			$table->date('date_du')->index();
			$table->enum('intervale', array('jour', 'sem', 'mois', 'jrmois', 'annee'));
			$table->integer('unit_intervale')->unsigned();
			$table->decimal('montant', 9,2);
			$table->string('nom', 100)->index();
			$table->string('description', 300)->nullable();
			$table->enum('credit_debit', array('rev', 'dep'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('budgets');
	}
}