<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSafeTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('safe_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('safe_id')->unsigned();
			$table->double('amount');
			$table->enum('type', array('in', 'out'));
			$table->string('receipt')->nullable();
			$table->integer('bank_account_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('safe_transactions');
	}
}