<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name', 100);
			$table->string('email', 100)->nullable();
			$table->string('country_code', 5);
			$table->string('phone', 20);
			$table->string('password', 255);
			$table->boolean('active')->default(true);
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('language_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}