<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserVerificationsTable extends Migration {

	public function up()
	{
		Schema::create('user_verifications', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('email')->default(false);
			$table->boolean('phone')->default(false);
			$table->boolean('national_id_card')->default(false);
			$table->boolean('driving_licence')->default(false);
			$table->string('national_id_card_front_image', 255)->nullable();
			$table->string('national_id_card_back_image', 255)->nullable();
			$table->string('driving_licence_back_image', 255)->nullable();
			$table->string('driving_licence_front_image', 255)->nullable();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_verifications');
	}
}