<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRidesTable extends Migration {

	public function up()
	{
		Schema::create('rides', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('pickup', 255);
			$table->string('dropoff', 255);
			$table->datetime('date_schedule');
			$table->smallInteger('passengers_limit');
			$table->boolean('instant_booking')->default(false);
			$table->double('price_per_seat');
			$table->boolean('is_publish')->default(false);
			$table->integer('vehicle_id')->unsigned();
			$table->timestamps();
			$table->boolean('middle_seat_empty')->default(true);
			$table->string('notes', 255)->nullable();
			$table->double('total_price')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('rides');
	}
}