<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletsTable extends Migration {

	public function up()
	{
		Schema::create('wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->double('requested_balance')->default('0');
			$table->double('wallet_balance')->default('0');
			$table->double('checkout_balance')->default('0');
			$table->double('maximum_balance')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('wallets');
	}
}