<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->mediumInteger('plate_number');
			$table->string('vehicle_name', 255);
			$table->string('image', 255);
			$table->string('color', 10);
			$table->integer('vehicle_model_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('vehicle_type_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}