<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable()->index();
			$table->string('email')->unique()->nullable();
			$table->enum('tipo', array('administrador', 'manager', 'entrenador'))->nullable();
			$table->string('rememberToken');
			$table->string('password');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}