<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('job_titles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->foreign('job_title_requirement_type_id')->references('id')->on('job_title_requirement_types')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_profile_job_title_requirement', function(Blueprint $table) {
			$table->foreign('user_profile_id')->references('id')->on('user_profiles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_profile_job_title_requirement', function(Blueprint $table) {
			$table->foreign('job_title_requirement_id')->references('id')->on('job_title_requirements')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('job_titles', function(Blueprint $table) {
			$table->dropForeign('job_titles_company_id_foreign');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->dropForeign('job_title_requirements_job_title_id_foreign');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->dropForeign('job_title_requirements_course_id_foreign');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->dropForeign('job_title_requirements_company_id_foreign');
		});
		Schema::table('job_title_requirements', function(Blueprint $table) {
			$table->dropForeign('job_title_requirements_job_title_requirement_type_id_foreign');
		});
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->dropForeign('user_profiles_company_id_foreign');
		});
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->dropForeign('user_profiles_job_title_id_foreign');
		});
		Schema::table('user_profile_job_title_requirement', function(Blueprint $table) {
			$table->dropForeign('user_profile_job_title_requirement_user_profile_id_foreign');
		});
		Schema::table('user_profile_job_title_requirement', function(Blueprint $table) {
			$table->dropForeign('user_profile_job_title_requirement_job_title_requirement_id_foreign');
		});
	}
}