<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('token', 'agent', 'attributes');

    public function passenger()
    {
        return $this->belongsTo('App\Passenger');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

}