<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('status', 'price', 'payment_status', 'store_id', 'is_active', 'client_id', 'email', 'phone');

    public function store()
    {
        return $this->belongsTo('App\Store', 'store_id');
    }

    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }

    public function orderItems()
    {
        return $this->hasMany('App\OrderItem');
    }

    public function items()
    {
        return $this->morphToMany('BusOrderItem', 'orderable');
    }

}