<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('bus_order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('service_uuid', 70)->nullable();
			$table->integer('passenger_id')->unsigned()->nullable();
			$table->smallInteger('seat_number')->unsigned()->nullable();
			$table->json('params')->nullable();
			$table->string('reserve_code', 100)->nullable();
			$table->string('status', 50)->nullable();
			$table->json('price')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bus_order_items');
	}
}