<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePassengersTable extends Migration {

	public function up()
	{
		Schema::create('passengers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name_fa', 70)->nullable();
			$table->string('first_name_en', 70)->nullable();
			$table->string('last_name_fa', 70)->nullable();
			$table->string('last_name_en', 70)->nullable();
			$table->enum('gender', array('man', 'woman'))->nullable();
			$table->date('birth_date')->nullable();
			$table->string('national_code')->nullable()->index()->default('10');
			$table->string('uuid', 70)->unique()->nullable();
			$table->bigInteger('client_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('passengers');
	}
}