<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItem extends Eloquent {

	protected $table = 'order_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'orderable_type', 'orderable_id');

	public function order()
	{
		return $this->belongsTo('App\Order', 'order_id');
	}

	public function orderable()
	{
		return $this->morphTo();
	}

}