<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('status', 50)->nullable();
			$table->json('price')->nullable();
			$table->string('payment_status', 50)->nullable();
			$table->mediumInteger('store_id')->unsigned()->nullable()->index();
			$table->boolean('is_active')->default(true);
			$table->bigInteger('client_id')->unsigned()->nullable();
			$table->string('email', 100)->nullable();
			$table->string('phone')->nullable()->default('12');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}