<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BusOrderItem extends Eloquent {

	protected $table = 'bus_order_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('service_uuid', 'passenger_id', 'seat_number', 'params', 'reserve_code', 'status', 'price');

	public function passenger()
	{
		return $this->hasOne('App\Passenger', 'passenger_id');
	}

	public function orderables()
	{
		return $this->morphMany('App\OrderItem', 'orderable');
	}

}