<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaypalsTable extends Migration {

	public function up()
	{
		Schema::create('paypals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('paypal_api_id', 150)->nullable();
			$table->string('cart', 100)->nullable();
			$table->timestamp('create_time')->nullable();
			$table->string('payer_country_code', 200)->nullable();
			$table->string('payer_name', 200)->nullable();
			$table->string('payer_id', 150)->nullable();
			$table->string('payment_method', 100)->nullable();
			$table->string('payment_status', 100)->nullable();
			$table->string('transactions_currency', 100)->nullable();
			$table->string('transactions_total', 200)->nullable();
			$table->text('items_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('paypals');
	}
}