<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('type', 30);
			$table->text('description')->nullable();
			$table->string('nif', 200)->nullable();
			$table->string('taxnumber', 150)->nullable();
			$table->string('contact', 50)->nullable();
			$table->string('activity_certificate', 200)->nullable();
			$table->timestamp('verified_at')->nullable();
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}