<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('firstname', 'lastname', 'email', 'ssn', 'passport', 'date_of_birth', 'identity_verified_at', 'role_id', 'location_id');
	protected $visible = array('firstname', 'lastname', 'email', 'ssn', 'passport', 'date_of_birth', 'identity_verified_at', 'role_id', 'location_id');

	public function locations()
	{
		return $this->belongsTo('App\Models\Location');
	}

	public function roles()
	{
		return $this->belongsTo('App\Models\Role');
	}

}