<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sellers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('sellers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('feedback_id')->references('id')->on('feedbacks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('store_payment_id')->references('id')->on('store_payments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('store_location_id')->references('id')->on('store_locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_payments', function(Blueprint $table) {
			$table->foreign('stripe_id')->references('id')->on('stripes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_payments', function(Blueprint $table) {
			$table->foreign('paypal_id')->references('id')->on('paypals')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_admins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_admins', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_locations', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('store_locations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('commands', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('commands', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('command_products', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('commands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('command_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('commands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('store_stripe_id')->references('id')->on('stripes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('store_paypal_id')->references('id')->on('paypals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_admins', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('commands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_promotions', function(Blueprint $table) {
			$table->foreign('promotion_id')->references('id')->on('promotions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_promotions', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('command_id')->references('id')->on('commands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('Categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('taxe_products', function(Blueprint $table) {
			$table->foreign('taxe_id')->references('id')->on('taxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taxe_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sellers', function(Blueprint $table) {
			$table->dropForeign('sellers_user_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_user_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_feedback_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_store_payment_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_store_location_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_location_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_store_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_image_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_store_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_product_id_foreign');
		});
		Schema::table('store_payments', function(Blueprint $table) {
			$table->dropForeign('store_payments_stripe_id_foreign');
		});
		Schema::table('store_payments', function(Blueprint $table) {
			$table->dropForeign('store_payments_paypal_id_foreign');
		});
		Schema::table('store_admins', function(Blueprint $table) {
			$table->dropForeign('store_admins_user_id_foreign');
		});
		Schema::table('store_admins', function(Blueprint $table) {
			$table->dropForeign('store_admins_store_id_foreign');
		});
		Schema::table('store_locations', function(Blueprint $table) {
			$table->dropForeign('store_locations_store_id_foreign');
		});
		Schema::table('store_locations', function(Blueprint $table) {
			$table->dropForeign('store_locations_location_id_foreign');
		});
		Schema::table('commands', function(Blueprint $table) {
			$table->dropForeign('commands_user_id_foreign');
		});
		Schema::table('commands', function(Blueprint $table) {
			$table->dropForeign('commands_location_id_foreign');
		});
		Schema::table('command_products', function(Blueprint $table) {
			$table->dropForeign('command_products_command_id_foreign');
		});
		Schema::table('command_products', function(Blueprint $table) {
			$table->dropForeign('command_products_product_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_store_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_command_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_store_stripe_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_store_paypal_id_foreign');
		});
		Schema::table('invoice_admins', function(Blueprint $table) {
			$table->dropForeign('invoice_admins_command_id_foreign');
		});
		Schema::table('product_promotions', function(Blueprint $table) {
			$table->dropForeign('product_promotions_promotion_id_foreign');
		});
		Schema::table('product_promotions', function(Blueprint $table) {
			$table->dropForeign('product_promotions_product_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_command_id_foreign');
		});
		Schema::table('deliveries', function(Blueprint $table) {
			$table->dropForeign('deliveries_service_id_foreign');
		});
		Schema::table('Categories', function(Blueprint $table) {
			$table->dropForeign('Categories_parent_id_foreign');
		});
		Schema::table('taxe_products', function(Blueprint $table) {
			$table->dropForeign('taxe_products_taxe_id_foreign');
		});
		Schema::table('taxe_products', function(Blueprint $table) {
			$table->dropForeign('taxe_products_product_id_foreign');
		});
	}
}