<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStripesTable extends Migration {

	public function up()
	{
		Schema::create('stripes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('card_number', 100)->unique()->nullable();
			$table->string('expiration_date', 100)->nullable();
			$table->string('security_code', 100)->nullable();
			$table->string('name_on_card', 100)->nullable();
			$table->string('currency', 50)->nullable();
			$table->string('stripe_api_id', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stripes');
	}
}