<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_sub_category', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_sub_category', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->dropForeign('sub_categories_category_id_foreign');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->dropForeign('types_sub_category_id_foreign');
		});
		Schema::table('service_sub_category', function(Blueprint $table) {
			$table->dropForeign('service_sub_category_service_id_foreign');
		});
		Schema::table('service_sub_category', function(Blueprint $table) {
			$table->dropForeign('service_sub_category_sub_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_service_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_type_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_category_id_foreign');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->dropForeign('offer_type_offer_id_foreign');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->dropForeign('offer_type_type_id_foreign');
		});
		Schema::table('offer_type', function(Blueprint $table) {
			$table->dropForeign('offer_type_service_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_district_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_order_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_product_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_cart_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_product_id_foreign');
		});
	}
}