<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAvatarsTable extends Migration {

	public function up()
	{
		Schema::create('avatars', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image', 256);
			$table->integer('model_index');
			$table->smallInteger('gender_index');
			$table->smallInteger('morphotype_index');
			$table->smallInteger('ethnic_index');
		});
	}

	public function down()
	{
		Schema::drop('avatars');
	}
}