<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientBackground extends Model 
{

    protected $table = 'patient_backgrounds';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function antecedent()
    {
        return $this->belongsTo('Antecedent');
    }

    public function custom_questions()
    {
        return $this->hasMany('CustomQuestion');
    }

}